require "TimedActions/ISBaseTimedAction"

TABAS_TubStopperAction = ISBaseTimedAction:derive("TABAS_TubStopperAction")

function TABAS_TubStopperAction:isValid()
    if self.plug then
        return self.tfc_Base ~= nil and not self.tfc_Base:hasTfc()
    end
    return self.tfc_Base ~= nil and self.tfc_Base:hasTfc()
end

function TABAS_TubStopperAction:waitToStart()
    if self.character:isAiming() then
        self.character:nullifyAiming()
    end
    if self.character:isSneaking() then
        self.character:setSneaking(false)
    end
    self.character:faceThisObject(self.tfc_Base.bathObject)
    return self.character:shouldBeTurning()
end

function TABAS_TubStopperAction:update()
end

function TABAS_TubStopperAction:start()
    self:setOverrideHandModels(nil, nil)
    self:setActionAnim("PutTubStopper")
end

function TABAS_TubStopperAction:stop()
	ISBaseTimedAction.stop(self)
end

function TABAS_TubStopperAction:perform()
    if self.plug then
        self.tfc_Base:create()
    else
        self.tfc_Base:remove()
    end

	-- needed to remove from queue / start next.
	ISBaseTimedAction.perform(self)
end

function TABAS_TubStopperAction:adjustMaxTime(maxTime)
    return maxTime
end

function TABAS_TubStopperAction:new(character, tfc_Base, plug)
    local o = ISBaseTimedAction.new(self, character)
    o.tfc_Base = tfc_Base
    o.plug = plug
    o.maxTime = 20

    o.ignoreHandsWounds = true
    o.useProgressBar = false
    o.caloriesModifier = 0
    return o
end